###############################################################################%
# This code is to generate the descriptive figures 
###############################################################################%

### ======= Load data ======= ###
rm(list = ls())
df_q <- read_csv('Data/data_us_quarterly.csv')
df_m <- read_csv('Data/data_us_mw.csv')

###############################################################################%
#### Figure 1 - Inflation and Long-Run Inflation Expectations  ####
###############################################################################%

ggplot() +
  geom_line(data = df_q %>% filter(!is.na(core_cpi_research)),
            aes(x = date, y = core_cpi_research, color = "Core CPI Inflation - Research Series")) +
  geom_line(data = df_q %>% filter(!is.na(forecast_10)),
            aes(x = date, y = forecast_10, color = "Long Run SPF Forecast of CPI Inflation")) +
  theme(axis.title.y = element_blank()) +
  scale_color_manual(
    values = c(
      "Core CPI Inflation - Research Series" = "#355070",     
      "Long Run SPF Forecast of CPI Inflation" = "#E56B6F"     
    )
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.99, 0.98), 
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4),  
    legend.justification = c("right", "top"), 
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  ) +
  guides(color = guide_legend(nrow = 2)) 
ggsave('Output/fig1.pdf', height = 4, width = 4)





###############################################################################%
#### Figure 5 - Estimates of the Output Gap in the U.S. ####
###############################################################################%

df_q %>% 
  drop_na(gap_gb_rt) %>% 
  pivot_longer(
    cols = c(gap_gb_rt, gap_gb_final, gap_cbo_final)
  ) %>% 
  ggplot(aes(date, value, color = name, linetype = name)) +
  geom_line() +
  scale_linetype_manual(
    values = c("solid","dashed","solid"),
    labels = c('CBO Last Vintage', 'Greenbook Last Vintage', "Greenbook Real Time")
  ) +
  scale_color_manual(values = c("#355070", "#E56B6F", "#E56B6F"),
                     labels = c('CBO Last Vintage', 'Greenbook Last Vintage', "Greenbook Real Time")) +
  labs(y = 'Percent') +
  scale_x_date(breaks = as.Date(paste0(seq(1960, 2020, by = 10), "-01-01")),
               date_labels = "%Y")
ggsave('Output/fig5.pdf', height = 2.6, width = 6)



###############################################################################%
#### Figure 14 - Core Inflation and One-Year Expected Inflation ####
###############################################################################%

### ======= Panel 1: 1-Year short ======= ###
df_q %>% 
  filter(
    date >= '2020-01-07',
    date <= '2025-04-01'
  ) %>%
  ggplot() +
  geom_line(aes(x = date, y = inflation_pce_core, color = "12-Month Core PCE Inflation")) +
  geom_line(aes(x = date, y = forecast_1year, color = "1-Year SPF Forecast of GDP Deflator Inflation")) +
  theme(axis.title.y = element_blank()) +
  scale_color_manual(
    values = c(
      "12-Month Core PCE Inflation" = "#355070",     
      "1-Year SPF Forecast of GDP Deflator Inflation" = "#E56B6F"     
    )
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.99, 0.16),
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4), 
    legend.justification = c("right", "top"),  
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  ) +
  guides(color = guide_legend(nrow = 2))
ggsave('Output/fig14_panel1.pdf', height = 4, width = 4)



### ======= Panel 2: 1-year long ======= ###
df_q %>% 
  filter(date >= '1978-01-01') %>% 
  ggplot() +
  geom_line(aes(x = date, y = inflation_pce_core, color = "12-Month Core PCE Inflation")) +
  geom_line(aes(x = date, y = forecast_1year, color = "1-Year SPF Forecast of GDP Deflator Inflation")) +
  theme(axis.title.y = element_blank()) +
  scale_color_manual(
    values = c(
      "12-Month Core PCE Inflation" = "#355070",     
      "1-Year SPF Forecast of GDP Deflator Inflation" = "#E56B6F"     
    )
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.99, 0.98),
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4), 
    legend.justification = c("right", "top"),  
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  ) +
  guides(color = guide_legend(nrow = 2))
ggsave('Output/fig14_panel2.pdf', height = 4, width = 4)



###############################################################################%
#### Figure B.2 - Core Inflation and One-Quarter Expected Inflation ####
###############################################################################%

### ======= Panel 1: 1-Quarter short ======= ###
df_q %>% 
  filter(
    date >= '2020-01-07',
    date <= '2025-04-01'
  ) %>%
  ggplot() +
  geom_line(aes(x = date, y = inflation_pce_core, color = "12-Month Core PCE Inflation")) +
  geom_line(aes(x = date, y = forecast_1quarter, color = "1-Quarter SPF Forecast of GDP Deflator Inflation")) +
  theme(axis.title.y = element_blank()) +
  scale_color_manual(
    values = c(
      "12-Month Core PCE Inflation" = "#355070",     
      "1-Quarter SPF Forecast of GDP Deflator Inflation" = "#E56B6F"     
    )
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.99, 0.16),
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4), 
    legend.justification = c("right", "top"), 
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  ) +
  guides(color = guide_legend(nrow = 2))
ggsave('Output/figB2_panel1.pdf', height = 4, width = 4)



### ======= Panel 2: 1-quarter long ======= ###
df_q %>% 
  filter(date >= '1978-01-01') %>% 
  ggplot() +
  geom_line(aes(x = date, y = inflation_pce_core, color = "12-Month Core PCE Inflation")) +
  geom_line(aes(x = date, y = forecast_1quarter, color = "1-Quarter SPF Forecast of GDP Deflator Inflation")) +
  theme(axis.title.y = element_blank()) +
  scale_color_manual(
    values = c(
      "12-Month Core PCE Inflation" = "#355070",     
      "1-Quarter SPF Forecast of GDP Deflator Inflation" = "#E56B6F"     
    )
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.99, 0.98),
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4),  
    legend.justification = c("right", "top"),  
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  ) +
  guides(color = guide_legend(nrow = 2))
ggsave('Output/figB2_panel2.pdf', height = 4, width = 4)



###############################################################################%
#### Figure 15 - Forward Guidance During Post-Covid Tightening ####
###############################################################################%


df_m %>% 
  filter(
    date >= '2021-01-01',
    date <= '2024-01-04'
  ) %>% 
  ggplot() +
  geom_line(aes(date, ffr, color = 'Effective Fed Funds Rate')) +
  geom_line(aes(date_m, gs2, color = '2-Year Nominal Rate')) +
  scale_color_manual(
    name = "Series",
    values = c(
      'Effective Fed Funds Rate' = "#355070",
      '2-Year Nominal Rate' = "#E56B6F"
    )
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.995, 0.17), 
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4),  # padding inside the legend box
    legend.justification = c("right", "top"),  # align anchor to top-right
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  )
ggsave('Output/fig15_panel1.pdf', height = 3.8, width = 4)


df_m %>% 
  filter(
    date >= '2021-01-01',
    date <= '2024-01-04'
  ) %>% 
  ggplot(aes(date_m, FII5, color = "5-Year TIPS Yield")) +  
  geom_line() +  
  scale_color_manual(
    name = "Legend Title",  
    values = c("5-Year TIPS Yield" = "#355070")
  ) +
  theme(
    axis.title.y = element_blank(),
    legend.position = c(0.99, 0.1), 
    legend.margin = margin(t = 2, r = 4, b = 2, l = 4),  
    legend.justification = c("right", "top"),  
    legend.background = element_rect(fill = "white", color = "grey80"),
    legend.title = element_blank()
  ) 
ggsave('Output/fig15_panel2.pdf', height = 3.8, width = 4)


