function path = sim_optimal_commit(p, VS, VD, rho, tsim, burn)

% This function computes the path of output gap, inflation, cumulated loss
% interest rate under the optimal policy with commitment, allowing for
% correlated shocks

% We allow for correlation in the shocks

% Simulate the path of exogenous cost push shock
u_s = zeros(tsim+1,1); 
u_d = zeros(tsim+1,1); 


Sigma = [VS^2,       rho*VS*VD;
         rho*VS*VD,  VD^2];

eps = mvnrnd([0 0], Sigma, tsim+1);

% Initialize
u_s(1) = eps(1,1);
u_d(1) = eps(1,2);

% Simulate the AR(1) processes
for t = 2:tsim+1
    u_s(t) = p.rho_S * u_s(t-1) + eps(t,1);
    u_d(t) = p.rho_D * u_d(t-1) + eps(t,2);
end

% Compute aux parameters
a = p.alpha / (p.alpha * (1 + p.beta) + p.kappa^2);
delta = (1 - sqrt(1 - 4 * p.beta * a^2)) / (2 * a * p.beta);
delta_aug = p.kappa * delta / (p.alpha * (1 - delta * p.beta * p.rho_S));


% Pre-allocate arrays for y, pi
y = zeros(size(u_s));
pi = zeros(size(u_s));


% Compute y and pi
y(1) = - delta_aug * u_s(1);
pi(1) = - p.alpha / p.kappa * y(1);
for t = 2:tsim+1
 
   y(t) = delta * y(t-1) - delta_aug * u_s(t);

   pi(t) =  - (p.alpha / p.kappa) * (y(t) - y(t-1));

end


% Per period loss 
loss = cumsum(pi.^2 +  p.alpha .* y.^2);

% Interest rate
i =  -log(p.beta) + (p.alpha / p.kappa - p.sigma) * (delta_aug * p.rho_S * u_s + (1-delta) * y) + p.sigma * u_d;

% Annualize (equivalent to 4x pi and i for the regressions)
y = y / 4;

% Vector X store values as IRF = (output gap, inflation, loss, nominal rate)
path = [y, pi, loss, i];

% burn in 
path(1:burn, :) = [];


end